;********************************************************************************
;* M O N O W A V E - Phase Acculumator oscillator program
;********************************************************************************
;* File: pao_2c.asm
;*
;* Copyright (C) Paul Maddox 1999-2005
;* Http://Www.Modulus-Music.Com/
;*
;* This program is free software; you can redistribute it and/or modify
;* it under the terms of the GNU General Public License as published by
;* the Free Software Foundation; either version 2 of the License, or (at
;* your option) any later version.
;*
;* This program is distributed in the hope that it will be useful, but
;* WITHOUT ANY WARRANTY; without even the implied warranty of
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;* General Public License for more details.
;*
;* You should have received a copy of the GNU General Public License
;* along with this program; if not, write to the Free Software
;* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;*
;*******************************************************************************
;
;********************************************************************************
;* Additional Information
;********************************************************************************
;*
;* Chip type           : ATtiny2313
;* Clock frequency     : 12.000000 MHz
;* Compiler	           : Atmel AVR Studio
;*
;*
;* One 8 port (PORTB) bit acts as datainput, another port performs, control,write and output
;* using ATtiny2313 @ 12Mhz
;
;*	Port B is BYTE input.
;*	Port D is control/output.
;*		      D2 = Write (input) , note this pin is also INT0 (falling edge, So active on HI>LO)
;*		      D0+D1 = command (01=PTC_Low, 10=PTC_Mid, 11=PTC_Upp) (Input)
;*		      D5 = Ouput
;*
;* PTC Value is obtained by multiplying OUTPUTF (Hz*256) by 35.656
;* (based on 4Mhz, divide by 3 for 12Mhz, k= 11.885333)
;* 35.656 was obtained from 1Khz needing PTC of $8B48 (35656)
;* Note values based on /256 for top octave
;*
;*	NOTE  Hz      Hz * 256  PTC(12Mhz)  PTC(HEX)   PTC = (Hz * 256) * k
;*	E6	   2637	   675072		  8023456		   7A6DA0
;*	D#6	  2489.7	 637363.2	 7575274		   7396EA
;*	D6	   2349.3	 601420.8	 7148087		   6D1237
;*	C#6	  2217.5	 567680		  6747066		   66FB3A
;*	C6	   2093	   535808		  6368257		   612C01
;*	B5	   1975.5	 505728		  6010746		   5BB77A
;*	A#5	  1864.7	 477363.2	 5673621		   569295
;*	A5	   1760	   450560		  5355056		   51B630
;*	G#5	  1661.2	 425267.2	 5054442		   4D1FEA
;*	G5	   1568	   401408		  4770868		   48CC34
;*	F#5	  1480	   378880		  4503115		   44B64B
;*	F5	   1396.9	 357606.4	 4250271		   40DA9F
;*
;* To get lower octaves shift right one bit for each octave
;*
;********************************************************************************

; *** Setup Constants

.include "tn2313def.inc"

.EQU	NULL = $00
.EQU	ALL  = $FF

; *** Setup Variables

.DSEG

.CSEG

.DEF	WORK      = r16 		; working register
.DEF	WORK2     = r17

.DEF    OUTPUT_HI = r18
.DEF	OUTPUT_LO = r19

.DEF	PTCA_Low  = r20
.DEF	PTCA_Mid  = r21
.DEF	PTCA_Upp  = r22

.DEF	ACCA_Low  = r23
.DEF	ACCA_Mid  = r24
.DEF	ACCA_Upp  = r25

.EQU	RESET=0

.ORG	RESET
		    rjmp Init		                    ; reset vector

.ORG	INT0addr
		    rjmp GetByte		                 ; INT0 Vector

; *** readports (ISR)

GetByte:
	     IN  YH, SREG		                 ; preserve status
	     IN  XH, PINB
	     IN  YL, PIND

	     ANDI YL, $03			                 ; filter out any extra bits

LOWPTC:
	     CPI	 YL, $01
	     BRNE MIDPTC				                ; if YL <> 01 then check next
	     MOV	 PTCA_Low, XH	             ; else load PTCA_Low with new value
	     RJMP PTCEND

MIDPTC:
	     CPI	 YL, $02
	     BRNE HIPTC				                 ; if YL <> 02 then check next
	     MOV	 PTCA_Mid, XH	             ; else load PTCA_Mid with new value
	     RJMP PTCEND

HIPTC:
	     CPI	 YL, $03
	     BRNE PTCEND				                ; if YL <> 03 then invalid control byte
     	MOV	 PTCA_Upp, XH	             ; else load PTC_Upp with new value

PTCEND:
	     OUT	 SREG, YH		                ; restore status
	     RETI						                     ; Return from interupt

; *** Initialization

Init:
	     LDI	ACCA_Low, $00
	     LDI	ACCA_Mid, $00
	     LDI	ACCA_Upp, $00

	     LDI	PTCA_Low, $01		            ; Setup control reg for OSC A
	     LDI	PTCA_Mid, $2C
	     LDI	PTCA_Upp, $61		            ; This will give C6
						                               ; MAX VALUE is 7FFFFF, NO MORE!!!!

	     LDI	Work, 0B00100000
	     OUT	DDRD, WORK		               ; Sets PORTD BIT5 as OUTPUT rest as input
	     LDI Work2, $00
	     OUT PORTD, Work2

	     LDI	Output_Hi, 0B00100000	     ; This is mask for osc output (BIT 5)
	     LDI	Output_Lo, 0B00000000

	     LDI	XH, $00
	     LDI	YL, $00

	     LDI	Work, 0b00000010
	     OUT	MCUCR, Work		              ; Setup MCUCR for falling edge interupts.

	     LDI Work, 0b01000000	          ; enable ext. INT0
	     OUT GIMSK, Work		              ; by setting interrupt mask reg. bit 6

	     SEI

; *** Main Loop

MAIN:
	     LDI	WORK, $00
	     ADD	ACCA_Low, PTCA_Low	        ; add two 24Bit numbers
	     ADC	ACCA_Mid, PTCA_Mid
	     ADC	ACCA_Upp, PTCA_Upp

	     BRMI MSBSET			                 ; if minus (ie MSB set) then change output byte.
	     OUT	PORTD, Output_Hi
	     RJMP MAIN

MSBSET:
      	OUT	PORTD, Output_Lo
	      RJMP MAIN
